import {NgbDateStruct, NgbTimeStruct} from "@ng-bootstrap/ng-bootstrap";
import {DatetimeFormatter} from "../../services/formatters/datetime/datetime-formatter.service";
import {FormatOptions} from "../../services/formatters/formatter.model";

export class DateTimeModel {
    hourStep = 1;
    minuteStep = 15;
    secondStep = 30;
    displaySeconds: boolean = false;
    date: NgbDateStruct;
    time: NgbTimeStruct;

    public constructor(init?: Partial<DateTimeModel>) {
        Object.assign(this, init);
    }

    public static toDateTimeStruct(formatter, dateString: string): DateTimeModel | null {
        if (!dateString) {
            return null;
        }
        const dateTimeStruct = formatter.userDateTimeFormatToStruct(dateString);

        if (!dateTimeStruct) {
            return null;
        }
        const {date, time} = dateTimeStruct;
        return new DateTimeModel({
            date: date,
            time: time
        });

    }

    public static internalToDateTimeStruct(formatter, dateString: string): DateTimeModel | null {
        if (!dateString) {
            return null;
        }
        const dateTimeStruct = formatter.internalDateTimeFormatToStruct(dateString);

        if (!dateTimeStruct) {
            return null;
        }
        const {date, time} = dateTimeStruct;
        return new DateTimeModel({
            date: date,
            time: time
        });

    }

    public toUserFormat(formatter: DatetimeFormatter, options?: FormatOptions): string {

        //prepare datetime string in yyyy-M-d H:m:s format (datetimepicker default)
        const dateString = [this.date.year, this.date.month, this.date.day].join('-');
        const timeString = [this.time.hour, this.time.minute, this.time.second].join(':');
        const datetimeString = [dateString, timeString].join(' ');

        const internalDateTimeString = formatter.toInternalFormat(datetimeString, {fromFormat: 'yyyy-M-d H:m:s'});

        //convert from yyyy-M-d H:m:s format to user format
        return formatter.toUserFormat(internalDateTimeString, {...options, fromFormat: 'yyyy-M-d H:m:s'});

    }
}
